/*******************************************

		dsPIC33FJ64GP706

LED control 5.5 project:
copied from functioning LEDcontrol5.4 (confirmed)
added code in between each four-piece eventTable row
	- default code
	- end of transmission of entire table (i.e. begin exec?)
	- indicate size of pieces




*******************************************/

#define round(x) ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))

#define DATA_OUT R1 
#define CLK_OUT R2
#define LATCH_EN R3

#define TONE R4//R4
#define SHOCK R5//L5//R5
#define LIGHT R6

#define LASER L2

int b;


#include <p33FJ64GP706.h>
#include "necp_v2.h"
#include "myuart.h"
#include "mytimers.h"
#include "init.h"
#include <stdio.h>



#define _ISR __attribute__((interrupt))

#define Fcy 10000000 // external oscillator (Fosc) = 20 MHz; Fcy = Fosc/2 = 10 MHz


void _ISR _T1Interrupt(void);
void _ISR _T2Interrupt(void);
void _ISR _T3Interrupt(void);
void _ISR _T4Interrupt(void);
void _ISR _T5Interrupt(void);





void initUART(void);
void initTimers(void);
void initIO(void);


void DelayMin(unsigned int);
void DelayS(unsigned int);
void DelayMS(unsigned int);
void DelayUS(unsigned int);







int masterLEDtable[10][8];		//on/off status for 10 pins, 8 LEDs each. (array of 10 arrays of 8 ints)


int curLEDbuf[8];				//one bank to update

long unsigned int masterTick = 0;
int curEventNum = 0;
int curEventTime = 0;
int curFn = 0;
int curCoord[2]; 				// (bank#,LED#)
int curBank;

#define LED_OFF 1
#define LED_ON 2
#define UPDATE_LEDS 3
#define TONE_ON 4
#define TONE_OFF 5
#define SHOCK_ON 6
#define SHOCK_OFF 7
#define UPDATE_BANK 8
#define UPDATE_ALL_LEDS 9
#define UART_RX 10
#define LIGHT_ON 14
#define LIGHT_OFF 15
#define LAZERZ 21
void outputBank(int);
void toggleLatch();
void getPrPs(int freq) ;



long unsigned int eventTable[100][4];



#include "serialRead.h"



void _ISR _T1Interrupt(void) {
	_T1IF = 0;
	masterTick++;

}


void _ISR _U2TXInterrupt(void) {
_U2TXIF = 0;
}








main() {



	initUART();
	initTimers();
	initIO();
	allOff();

	ptr = eventTable;
	masterPtr = masterLEDtable;
	realTime=0;


	
	if (_RB0) { 
		
		realTime=1;
		while (1) {
			if(serFlag ==1){
			serFlag=0;
			serialRead();
			}
		}
	} else {
	
		while(1) {
			
			while(curEventNum <100) {
						
				if (serFlag ==1) {
					serFlag=0;
					serialRead();
				}	
			
			
			
			
				curEventTime = eventTable[curEventNum][0]; //1st column of eventTable contains event timestamp
			
				if (masterTick >= curEventTime && T1CONbits.TON == 1) {
		
					curFn = eventTable[curEventNum][1];
					switch ( curFn ) {
						case 0:
							break;	
						case LED_OFF:
						
						case LED_ON: 
							curCoord[0] = eventTable[curEventNum][2]; 	//3rd col contains bank (pin, chip, etc.) coordinate (4th contains LED coordinate)
							curCoord[1] = eventTable[curEventNum][3]; 	//4th col
							
							if (curFn == LED_OFF) { 
								*(masterPtr + (curCoord[0]*8 + curCoord[1])) = 0;	
							} else if (curFn == LED_ON) {
								*(masterPtr + (curCoord[0]*8 + curCoord[1])) = 1;								
							}
							outputBank(curCoord[0]);				
							break;
						case TONE_ON: 
							TONE = 1;
							break;
						case TONE_OFF: 
							TONE = 0;
							U1TXREG=1;
							break;
						case SHOCK_ON:
							SHOCK = 1;
							break;
						case SHOCK_OFF:
							SHOCK = 0;
							break;
						case LIGHT_ON:
							LIGHT = 1;
							break;
						case LIGHT_OFF:
							LIGHT = 0;
							break;
						case UPDATE_BANK: 
							
							break;
						case UPDATE_ALL_LEDS: 
							
							break;
						case UART_RX:
							U2TXREG = 1;
		
							while(!_U2RXIF);
							allOn();
							break;
						case 20:
						//	L2 = !L2;
							break;
						case LAZERZ:
							LASER = 0;
							if (eventTable[curEventNum][2]==0) {
							
								T2CONbits.TON = 0; 
								_T2IE = 0;
								LASER =0;
							} else {
								getPrPs(eventTable[curEventNum][2]);
								//PR2 = eventTable[curEventNum][2];
								//T2CONbits.TCKPS = eventTable[curEventNum][3];
								//PR2 = 19000;
								//T2CONbits.TCKPS = 3;
								T2CONbits.TON = 1; 
								_T2IE = 1;
							}
							break;							


						
		
					} //end switch (curFn)
		
					curEventNum++;
				} //end if
			}
	
				curEventTime = 0;
				curEventNum = 0;
				masterTick = 0;
		} //end while(1)
			
	
	} //end if (_R9G)
	
	allOff();
	while(1);
}

void toggleLatch (void) {
		LATCH_EN = 1;
		int m=1;
		for ( m = 16; m > 0; m--) { 
		}		
		LATCH_EN = 0;
}



void outputBank (int curBank) {

	int m=1;
	CLK_OUT=0;
	for ( m = 0; m <8; m++) {   //warning! separate clocks and latches for all, or just separate latches?
		DATA_OUT = masterLEDtable[curBank][m];  //go through 8 LEDs in this bank's row
		CLK_OUT = !CLK_OUT;
		//delay here slightly?
		CLK_OUT = !CLK_OUT;
	}	
	CLK_OUT=0;
	toggleLatch();

}





long unsigned int rawPR; //raw timer register value
//for pulsed laser:
//calculate PR (timer register) and PS (timer prescaler)
void getPrPs(int freq) {
	
	rawPR = 5000000/freq;//(1/(2*freq))*1000000*10;
	/*
	PR2 = 19000;
	T2CONbits.TCKPS = 3;
	*/
	if (rawPR > 65535){
        if (rawPR/8 > 65535) {
            if (rawPR/64 > 65535) {
                PR2=rawPR/256;
                T2CONbits.TCKPS =3;
            } else {
                PR2=rawPR/64;
                T2CONbits.TCKPS =2;
            } 
        } else {
            PR2=rawPR/8;
            T2CONbits.TCKPS =1;
        }
    } else {
	    PR2=rawPR;
	    T2CONbits.TCKPS =0;
	}
}